 ; Ŀ
 ;   Bomex - extract bom numbers and counts to a csv file.                 
 ;   Copyright 2005, 2007 by Rocket Software Ltd.                          
 ;   A lot of this should be cleaned up.                                   
 ; 

 ; Ŀ
 ;   Bomp - count BOM tag numbers.                                         
 ;   Calls Croco, Horiz, and Lowest.                                       
 ;   Returns a list of Bom tag item numbers and quantities.                
 ; 
 (DEFUN BOMP (/ ss num enam bomnum typl typr quant isstr sub subnum strsub
                                                             gnusub malist)
 ; Ŀ
 ;   Get all material tag blocks.                                          
 ; 
  (setq ss (ssget "x" '((-4 . "<and") (0 . "insert") (66 . 1)
                                      (2 . "matltag,bomtag,bomtag2")
                        (-4 . "and>"))))
 ; Ŀ
 ;   Step through the selection set, count each type.                      
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (croco (cdr (assoc 10 (entget enam))))
         (setq num (1+ num))
         (setq bomnum (cdr (assoc 1 (entget (setq enam (entnext enam))))))
         (setq typl (cdr (assoc 1 (entget (setq enam (entnext enam))))))
         (setq typr (cdr (assoc 1 (entget (setq enam (entnext enam))))))
 ; Ŀ
 ;   Find which attribute contains the quantity, save it.                  
 ;   This is a bit kludgy.  Actually very.                                 
 ; 
         (setq quant ())
         (if (and (not (member typl '("" " " "  " "-" "..." "_")))
                  (not (= (substr typl 1 4) "NOTE")))
             (setq quant typl))
         (if (and (not (member typr '("" " " "  " "-" "..." "_")))
                  (not (= (substr typr 1 4) "NOTE")))
             (setq quant typr))
 ; Ŀ
 ;   Extract the number from the variable.                                 
 ; 
         (cond ((null quant)
                (setq quant 1))
               ((or (= (type (read quant)) 'INT)
                    (= (type (read quant)) 'REAL))
                (setq quant (read quant)))
               ((or (= (strcase (substr quant 1 3) t) "typ")
                    (and (= (strcase (substr quant 1 1) t) "a")
                         (= (strcase (substr quant 3 3) t) "r")))
                (setq quant "A/R"))
               ((= (strcase (substr quant 1 1) t) "x")
                (setq quant (read (substr quant 2))))
               ((= (strcase (substr quant (strlen quant)) t) "x")
                (setq quant (read (substr quant 1 (1- (strlen quant))))))
               (T (setq quant 1)))
 ; Ŀ
 ;   See if the Quant variable contains a string or a number.              
 ; 
         (if (= (type quant) 'STR)
             (setq isstr t)
             (setq isstr ()))
 ; Ŀ
 ;   Add the number tag or the tag and number to the master list.          
 ;   See if the second atom in the list is a string.                       
 ; 
         (setq sub (assoc bomnum malist))
         (setq subnum (cadr sub))
         (if (= (type subnum) 'STR)
             (setq strsub t)
             (setq strsub ()))
 ; Ŀ
 ;   Cond: the main number attribute was empty - ignore the block.         
 ; 
         (cond ((member bomnum '("" " " "  " "-" "..." "_")))
 ; Ŀ
 ;   Cond: there is a sublist matching the Bom No. and (quant is a string  
 ;   or subnum is a string.)                                               
 ; 
               ((and sub (or isstr strsub))
                (setq gnusub (list (car sub) "A/R"))
                (setq malist (subst gnusub sub malist)))
 ; Ŀ
 ;   Cond: there is a sublist matching the Bom No. and Quant is a number   
 ;   and subnum is a number.                                               
 ; 
               ((and sub (null isstr) (null strsub))
                (setq gnusub (list (car sub) (+ subnum quant)))
                (setq malist (subst gnusub sub malist)))
 ; Ŀ
 ;   Cond: there is no matching sublist.                                   
 ; 
               ((null sub)
                (setq gnusub (list bomnum quant))
                (setq malist (cons gnusub malist)))))
 ; Ŀ
 ;   Malist should now contain all the bom data.                           
 ; 
  (setq malist (horiz malist))
 malist)
 ; Ŀ
 ;   Bomp end.                                                             
 ; 

 ; Ŀ
 ;   Bullax - write a list of lists to a csv file.                         
 ;   Very hacky, needs a proper list to string converter.                  
 ;   Arguments: Lista, a list.                                             
 ;              Filnam, a filename.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BULLAX (lista filnam / fn sub nxtstr nxnx str)
  (setq fn (open filnam "w"))
  (while (setq sub (car lista))
         (setq lista (cdr lista))
         (setq nxtstr (car sub))
         (setq nxnx (cadr sub))
         (cond ((= (type nxtstr) 'INT)
                (setq nxtstr (itoa nxtstr)))
               ((= (type nxtstr) 'REAL)
                (setq nxtstr (rtos nxtstr))))
         (cond ((= (type nxnx) 'INT)
                (setq nxnx (itoa nxnx)))
               ((= (type nxnx) 'REAL)
                (setq nxnx (rtos nxnx))))
         (setq str (strcat nxtstr "," nxnx))
         (write-line str fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Bullax end.                                                           
 ; 

 ; Ŀ
 ;   Cdfout - suck a cdf file into a list.                                 
 ;   Arguments: filnam, a filename.                                        
 ;   Calls Csplit.                                                         
 ;   Returns a list of lists of strings.                                   
 ; 
 (DEFUN CDFOUT (filnam / fn linn llist malist num gnulis suba)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (if (/= linn "")
                      (progn
                           (setq llist (csplit linn))
 ; Ŀ
 ;   Capitalize the list (i.e. all substrings.)                            
 ; 
                           (setq num 0)
                           (setq gnulis ())
                           (while (setq suba (nth num llist))
                                  (setq suba (strcase suba))
                                  (setq num (1+ num))
                                  (setq gnulis (cons suba gnulis)))
                           (setq gnulis (reverse gnulis))
 ; Ŀ
 ;   If the first element (the pile name) isn't a number then replace it   
 ;   with "0" so that encountering something non-numerical won't crash     
 ;   horiz.  This is not an ideal solution.                                
 ; 
                           (if (/= (type (read (car gnulis))) 'INT)
                               (progn
                                    (setq bada t)
                                    (setq gnulis (cons "0" (cdr gnulis)))
                                    (prompt "\n* Non-numerical pile name in existing data file replaced with 0.")))
                           (setq malist (append malist (list gnulis))))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Cdfout end.                                                           
 ; 

 ; Ŀ
 ;   Combix - combine lists of lists, taking the first element to be a     
 ;   name and the second to be an amount.  If the second element isn't     
 ;   a number then it replaces the existing second element.                
 ;   This is so that adding 2 to "Typ." gives "Typ." and not 2, since      
 ;   "Typ." may stand for any number from zero up.                         
 ;   Arguments: Lista, a data list.                                        
 ;              Listb, anothr data list.                                   
 ;   Calls nothing, returns a combined data list.                          
 ; 
 (DEFUN COMBIX (lista listb / num asub bsub caras numa numb gnusub)
  (setq num 0)
 ; Ŀ
 ;   Check each sublist from Lista to see if there is a matching sublist   
 ;   (i.e. one with the same leading string) in Listb.                     
 ; 
  (while (setq asub (nth num lista))
         (setq num (1+ num))
 ; Ŀ
 ;   If there is a matching list combine the two.                          
 ; 
         (cond ((setq bsub (assoc (setq caras (car asub)) listb))
                (setq numa (cadr asub))
                (if (and (= (type numa) 'STR)
                         (= (type (read numa)) 'INT))
                    (setq numa (read numa)))
                (setq numb (cadr bsub))
                (if (and (= (type numb) 'STR)
                         (= (type (read numb)) 'INT))
                    (setq numb (read numb)))
                (cond ((and (equal (type numa) 'INT)
                            (equal (type numb) 'INT))
                       (setq gnusub (list caras (+ numa numb))))
                      ((not (equal (type numa) 'INT))
                       (setq gnusub asub))
                      ((not (equal (type numb) 'INT))
                       (setq gnusub bsub)))
 ; Ŀ
 ;   Substitute the new sublist back into Listb.                           
 ; 
                (setq listb (subst gnusub bsub listb)))
 ; Ŀ
 ;   If there is no matching list combine the two.                         
 ; 
               (T (setq listb (cons asub listb)))))
 listb)
 ; Ŀ
 ;   Combix end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Croco - draw a temporary marker.                           
 ; 
 (DEFUN CROCO (pa / blip colo colo2 rad rad2)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq colo 140)
  (setq colo2 170)
  (setq rad (/ (getvar "viewsize") 35))
  (setq rad2 (/ (getvar "viewsize") 45))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (/ pi 2) rad) (polar pa (* 1.5 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
  (grdraw (polar pa 0 rad) (polar pa pi rad) colo)
  (grdraw (polar pa (/ pi 8) rad2) (polar pa (* 1.125 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.375) rad2) (polar pa (* 1.375 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.625) rad2) (polar pa (* 1.625 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.875) rad2) (polar pa (* 1.875 pi) rad2) colo2)
  (grdraw (polar pa 0 rad2) (polar pa pi rad2) colo2)
  (grdraw (polar pa (/ pi 2) rad2) (polar pa (* 1.5 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.75) (* rad 0.75))
          (polar pa (* pi 1.75) (* rad 0.75)) colo2)
  (grdraw (polar pa (* pi 0.25) (* rad 0.75))
          (polar pa (* pi 1.25) (* rad 0.75)) colo2)
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Croco end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Horiz - put a list in order by the first number in each    
 ;   sublist.  Takes one argument, a list, which it returns in order       
 ;   from smallest to largest first element.                               
 ; 
 (DEFUN HORIZ (nexlst / low nxtsub hrzlst newlst orderd)
  (while nexlst
        (setq low (lowest nexlst))                 ; lowest leading number
        (while (and nexlst (setq nxtsub (nth 0 nexlst)))
               (if (equal low (read (car nxtsub)))
                   (setq hrzlst (append hrzlst (list nxtsub)))
                   (setq newlst (append newlst (list nxtsub))))
               (setq nexlst (cdr nexlst)))          ; remove 1st ent from list
        (setq orderd (append orderd hrzlst))        ; add lev sublst to levels
        (setq hrzlst ())                            ; set to () for next loop
        (setq nexlst newlst)                        ; nexlst reconstituted
        (setq newlst ()))                           ; empty new list & reuse
  orderd)
 ; Ŀ
 ;   Horiz end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lowest - find the smallest leading number in a sublist     
 ;   of the list Nexlst which is the sole argument.                        
 ; 
 (DEFUN LOWEST (nexlst / num minlst neth)
  (setq num 0)
  (setq minlst (list min))
  (while (setq neth (nth num nexlst))
         (if neth (setq minlst (append minlst (list (read (car neth))))))
         (setq num (1+ num)))
 (eval minlst))
 ; Ŀ
 ;   Lowest end.                                                           
 ; 

 ; Ŀ
 ;   Wisp - see if an ss is in paper or model space or both.               
 ;   Arguments: Ss, either a selection set or a block name.                
 ;   Returns a list: (("space_name" number) ...)                           
 ; 
 (DEFUN WISP (ss / num enam space sub numa split)
 ; Ŀ
 ;   If ss was a string (i.e. a name rather than an ss) then get an ss     
 ;   of all the inserts of that type in the drawing.                       
 ; 
  (if (= (type ss) 'STR)
      (setq ss (ssget "X" (list (cons 2 ss)))))
 ; Ŀ
 ;   Count the entities in each space.                                     
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq space (cdr (assoc 410 (entget enam))))
         (cond ((setq sub (assoc space split))
                (setq numa (list space (1+ (cadr sub))))
                (setq split (subst numa sub split)))
               (T
                (setq split (cons (list space 1) split)))))
 split)
 ; Ŀ
 ;   Wisp end.                                                             
 ; 

 ; Ŀ
 ;   Bomex.                                                                
 ; 
 (DEFUN C:BOMEX (/ blnam *error* lista filnam namf exlist)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq blnam "matltag,bomtag")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if (/= shk "Function cancelled") (write-line shk))
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Mention if there are blocks in different spaces.                      
 ; 
  (if (> (length (wisp blnam)) 1)
      (prompt "* Caution: Bom blocks located in more than one space. *"))
 ; Ŀ
 ;   Call Bomp to extract the attribute values from each bom block into a  
 ;   list of lists.                                                        
 ; 
 (if (not (setq lista (bomp)))
      (write-line "No Bom blocks found.")
      (progn
           (setq filnam (strcat (getvar "dwgprefix") "Bom.csv"))
 ; Ŀ
 ;   If the file exists, read it into its own list.                        
 ; 
           (if (setq namf (findfile filnam))
               (progn
                    (setq exlist (cdfout namf))
 ; Ŀ
 ;   Combine the file list and the drawing list.                           
 ; 
                    (setq lista (combix lista exlist))))
 ; Ŀ
 ;   Sort the list by first number.                                        
 ; 
           (setq lista (horiz lista))
 ; Ŀ
 ;   Write the list to the csv file.                                       
 ; 
           (bullax lista filnam)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
   (command ".undo" "end")
 (princ))